<div {{$attributes->class(["row location-picker"])}}>
    <div class="col-md-4">
        <div class="form-group">
            <label for="country">@lang("app.country") <span class="text-danger">*</span></label>
            <select id="country" name="country_id" class="form-control select2" data-placeholder="@lang('app.select-country')">
                @if($selectedCountry)
                    <option value="{{ $selectedCountry->id }}" selected>{{ $selectedCountry->name }}</option>
                @endif
            </select>
        </div>
    </div>

    <div class="col-md-4">
        <div class="form-group">
            <label for="state">@lang("app.state") <span class="text-danger">*</span></label>
            <select id="state" name="state_id" class="form-control select2" data-placeholder="@lang('app.select-state')">
                @if($selectedState)
                    <option value="{{ $selectedState->id }}" selected>{{ $selectedState->name }}</option>
                @endif
            </select>
        </div>
    </div>

    <div class="col-md-4">
        <div class="form-group">
            <label for="city">@lang("app.city") <span class="text-danger">*</span></label>
            <select id="city" name="city_id" class="form-control select2" data-placeholder="@lang('app.select-city')">
                @if($selectedCity)
                    <option value="{{ $selectedCity->id }}" selected>{{ $selectedCity->name }}</option>
                @endif
            </select>
        </div>
    </div>
</div>
@once
@push('style')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@push('script')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2').select2({
        width: '100%',
        allowClear: true
    });

    // Initialize country select2 with AJAX
    $('#country').select2({
        width: '100%',
        allowClear: true,
        ajax: {
            url: '{{ route('location.countries') }}',
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    search: params.term,
                    page: params.page || 1
                };
            },
            processResults: function(data) {
                return {
                    results: data.data.map(country => ({
                        id: country.id,
                        text: country.name
                    })),
                    pagination: {
                        more: data.next_page_url ? true : false
                    }
                };
            },
            cache: true
        },
        placeholder: 'Select Country'
    });

    // Handle country change
    $('#country').on('change', function() {
        const countryId = $(this).val();
        $('#state').val(null).trigger('change');
        $('#city').val(null).trigger('change');

        if (countryId) {
            initializeStateSelect(countryId);
        }
    });

    // Handle state change
    $('#state').on('change', function() {
        const stateId = $(this).val();
        $('#city').val(null).trigger('change');

        if (stateId) {
            initializeCitySelect(stateId);
        }
    });

    function initializeStateSelect(countryId) {
        $('#state').select2({
            width: '100%',
            allowClear: true,
            ajax: {
                url: `{{ route('location.states') }}`,
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        search: params.term,
                        country_id: countryId,
                        page: params.page || 1
                    };
                },
                processResults: function(data) {
                    return {
                        results: data.data.map(state => ({
                            id: state.id,
                            text: state.name
                        })),
                        pagination: {
                            more: data.next_page_url ? true : false
                        }
                    };
                },
                cache: true
            },
            placeholder: 'Select State'
        });
    }

    function initializeCitySelect(stateId) {
        $('#city').select2({
            width: '100%',
            allowClear: true,
            ajax: {
                url: `{{ route('location.cities') }}`,
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        search: params.term,
                        state_id: stateId,
                        page: params.page || 1
                    };
                },
                processResults: function(data) {
                    return {
                        results: data.data.map(city => ({
                            id: city.id,
                            text: city.name
                        })),
                        pagination: {
                            more: data.next_page_url ? true : false
                        }
                    };
                },
                cache: true
            },
            placeholder: 'Select City'
        });
    }

    // Initialize state select2 if country is pre-selected
    @if($selectedCountry)
        initializeStateSelect({{ $selectedCountry->id }});
    @endif

    // Initialize city select2 if state is pre-selected
    @if($selectedState)
        initializeCitySelect({{ $selectedState->id }});
    @endif
});
</script>
@endpush
@endonce
